
# generation and density functions for a mixture of two gaussians

# mix = probability of value coming from the first gaussian

rmixture <- function(n, mean1=-2, sd1=1, mean2=2, sd2=1, mix=0.5){
    x1 <- rnorm(n, mean=mean1, sd=sd1)
    x2 <- rnorm(n, mean=mean2, sd=sd2)
    x <- x1
    mind <- runif(n) < mix
    x[mind] <- x2[mind]
    return(x)
}

dmixture <- function(x, mean1=-2, sd1=1, mean2=2, sd2=1, mix=0.5){
    d1 <- dnorm(x, mean=mean1, sd=sd1)
    d2 <- dnorm(x, mean=mean2, sd=sd2)
    d <- d2 * mix + d1 * (1 - mix)
    return(d)
}


# Copyright 2014 Univ. Corp for Atmos. Research
# Author: Seth McGinnis, mcginnis@ucar.edu
