###########
### Generates figures for paper
### source after running compare-techniques.R


# store graphics handles to copy plots to file later on
graphics.off()
figures  <- c()


# better distribution names for figure titles
dnames <- c(norm="Normal", gamma="Gamma", mixture="Mixture")

# better metric names for panel titles
mnames <- c(MAE="Mean Absolute Error", RMSE="    Root Mean Square Error",
            MaxE="Maximum Error", LTE="Left Tail Error",
            RTE="Right Tail Error", KS="K-S Statistic")


################
### boxplots of various bias-correction quality metrics (figs 2 and 3)

## gamma omitted to save space
#for (distro in c("norm", "gamma", "mixture")){

for (distro in c("norm", "mixture")){
    
    data <- all.result[[distro]]

    ################
    ### Calculate metrics

    error <- lapply(data, function(x){x - data[["oracle"]]})
    # discard oracle and uncorrected 
    error["oracle"] <- NULL
    error["uncorrected"] <- NULL


    metrics <- list()

    metrics[["MAE"]] <- 
        lapply(error, function(x){apply(x, 1, function(y){mean(abs(y))})})
    metrics[["RMSE"]] <- 
        lapply(error, function(x){apply(x, 1, function(y){sqrt(mean(y^2))})})
    metrics[["MaxE"]] <- 
        lapply(error, function(x){apply(x, 1, function(y){max(abs(y))})})

    
    N <- Niter * Ndata
    Ntail <- round(N * 0.01)
    ltailindex <- order(data[["oracle"]])[1:Ntail]
    rtailindex <- order(data[["oracle"]])[N - (1:Ntail) + 1]
    metrics[["LTE"]] <- lapply(error, "[", ltailindex)
    metrics[["RTE"]] <- lapply(error, "[", rtailindex)

#    # clip extreme ECDF outliers from gamma LTE to keep plot legible
#    if(distro=="gamma"){
#        clip <- metrics[["LTE"]][["ecdf"]]
#        clip[clip > 0.5] <- 0.5
#        nclip <- sum(clip == 0.5)
#        print(paste0(nclip, "/" ,Ntail ," clipped from gamma left tail error"))
#        metrics[["LTE"]][["ecdf"]] <- clip
#    }

    
    temp1 <- list()
    for(m in names(error)){
        temp2 <- c()
        for(i in 1:Niter){
            temp2[i] <- ks.test(data[["oracle"]][i, ], data[[m]][i, ])$statistic
        }
        temp1[[m]] <- temp2
    }
    metrics[["KS"]] <- temp1

    for(m in names(metrics)){
        names(metrics[[m]]) <- toupper(names(metrics[[m]]))
    }



    ################
    ### Boxplot metrics

    letter = paste0(c('a','b','c','d','e','f'),")")
    names(letter) = names(metrics)
    
    x11(width=9, height=7.5)
    figures[paste0("metrics.", distro)] <- dev.cur()
    par(mfrow=c(2, 3), oma=c(1, 1, 3, 1), mai=c(0.5, 0.4, 0.6, 0.2))
    for(m in names(metrics)){
        boxplot(metrics[[m]], at=c(1:6, 8, 9), las=2)
        mtext(mnames[m], adj=0.5, line=1, font=2)
        mtext(letter[m], adj=0, line=1)        
        if(m == "LTE" || m == "RTE"){abline(h=0, col="gray")}
        if(m == "LTE" && distro == "gamma"){
            arrows(1.3, 0.45, 1.3, 0.5, length=0.05)
        }
    }
    mtext(paste(dnames[distro], "Distribution"), outer=TRUE, cex=1.5)

}



################
### Barplot of timings (fig 4)

x11()
figures["timing"] <- dev.cur()

timing <- t(sapply(all.time, rbind))
colnames(timing) <- toupper(names(all.time[[1]]))

barplot(timing, las=2, log="y", beside=TRUE, axis.lty=1, ylim=c(1,1000))

title("Computation time (sec)")

legend("topleft", dnames, fill=gray.colors(3), inset=0.05)

print("Timing:")
print(timing)

################
### copy plots to file

figno <- 2
for (d in names(figures)){
    if(any(grep("metrics", d))){
        w <- 9; h <- 7.5
    } else {
        w <- 7; h <- 7
    }

    dev.set(figures[d])
    dev.copy(pdf, width=w, height=h,
             file=paste("figures/fig", figno, d, "pdf", sep='.'))
    dev.off()

    dev.set(figures[d])
    dev.copy(png, width=w, height=h, units="in", res=120,
             file=paste("figures/fig", figno, d, "png", sep='.'))
    dev.off()
    
    figno <- figno + 1
}


# Copyright 2014 Univ. Corp for Atmos. Research
# Author: Seth McGinnis, mcginnis@ucar.edu
