"nnreg" <-
function (x, y, k1 = NULL, k2 = NULL, start = NULL, ngrind = 250, 
    ntries = 100, npol = 20, ftol1 = 1e-06, ftol2 = 1e-09, itmax1 = 250, 
    itmax2 = 10000, fitted.values = FALSE, all.fits = FALSE, 
    greedy = FALSE, seed = NULL, fast = FALSE, na.rm = TRUE, 
    verbose = FALSE, too.fast = FALSE, just.setup = FALSE, just.read = FALSE, 
    batch.inname = "nnreg.input", batch.outname = "nnreg.output") 
{
    lags <- NA
    call <- match.call()
    y <- c(y)
    x <- as.matrix(x)
    d <- ncol(x)
    nxc <- d
    ind <- !is.na(y)
    if (sum(ind) < length(ind)) {
        cat("NA's found and removed from data set!", fill = TRUE)
        y <- y[ind]
        x <- x[ind, ]
    }
    if (length(dimnames(x)) != 2) {
        dimnames(x) <- list(format(1:nrow(x)), paste("X", 1:d, 
            sep = ""))
    }
    if (length(dimnames(x)[[1]]) == 0) {
        dimnames(x)[[1]] <- format(1:nrow(x))
    }
    if (length(dimnames(x)[[2]]) == 0) {
        dimnames(x)[[2]] <- paste("X", 1:d, sep = "")
    }
    nx <- nrow(x)
    if (is.null(seed)) {
        seed <- as.integer(runif(1) * 125000)
    }
    if (fast) {
        ngrind <- 50
        ntries <- 100
        npol <- 10
        ftol1 <- 1e-04
        ftol2 <- 1e-08
    }
    if (too.fast) {
        ngrind <- 10
        ntries <- 5
        npol <- 1
        ftol1 <- 0.001
        ftol2 <- 1e-06
    }
    if (all.fits) {
        iprint <- 1
    }
    else {
        iprint <- 0
    }
    if (greedy) {
        igreed <- 1
    }
    else {
        igreed <- 0
    }
    if (!is.null(start)) {
        ngrind <- -1
        if (is.null(start$k) | is.null(start$theta)) {
            stop("starting values must be  a list with components k and theta")
        }
        k1 <- start$k
        start <- start$theta
    }
    else {
        start <- 0
    }
    if (is.null(k2)) {
        k2 <- k1
    }
    if (verbose) {
        cat("k1,k2", k1, k2, fill = TRUE)
    }
    ierr <- ifelse(verbose, 1000, 0)
    inputi <- as.integer(c(nx, nxc, ngrind, ntries, npol, iprint, 
        igreed, seed, itmax1, itmax2, k1, k2))
    inputr <- as.double(c(ftol1, ftol2))
    nr <- 0
    noutp <- ifelse(iprint == 0, 1, npol)
    for (kk in k1:k2) {
        if ((kk != k1) & (greedy)) {
            hold <- 3 + 2 * nxc + 2 + (nxc + 2) + 1
        }
        else {
            hold <- 3 + 2 * nxc + 2 + kk * (nxc + 2) + 1
        }
        nr <- nr + hold * noutp
    }
    if (verbose) {
        cat(nr, " size of outputr", fill = TRUE)
    }
    ni <- 20
    if (just.setup) {
        write(batch.inname, batch.inname, ncol = 1)
        write(batch.outname, batch.inname, append=TRUE, ncol = 1)
        write(inputi, batch.inname, ncol = 1, append = TRUE)
        write(inputr, batch.inname, ncol = 1, append = TRUE)
        write(ierr, batch.inname, ncol = 1, append = TRUE)
        write(c(y), batch.inname, ncol = 1, append = TRUE)
        write(t(x), batch.inname, ncol = nxc, append = TRUE)
        temp <- match.call()
        temp$just.read <- TRUE
        temp$just.setup <- FALSE
        write("To read in output file:", batch.inname, ncol=1, append=TRUE)
        write(deparse(temp), batch.inname, append = TRUE)
                return(temp)
    }
    if (!just.read) {
        outF <- .Fortran("nnreg", nmaxa = as.integer(nrow(x)), 
            ntemp = as.integer(nrow(x)), xtemp = as.double(x), 
            ytemp = as.double(y), inputi = inputi, inputr = inputr, 
            strt = as.double(start), nr = as.integer(nr), outputr = as.double(rep(0, 
                nr)), ni = as.integer(20), outputi = as.integer(rep(0, 
                ni)), ierr = as.integer(ierr))[c("outputr", "outputi", 
            "ierr")]
        nr <- outF$outputi[1]
    }
    else {
        checkname<- scan(batch.outname, what="a",nlines=1)
        if( checkname!=batch.inname) {
       stop(paste(
"Mismatch of input files. Batch input file is: ", batch.inname, 
      "but output file contains:", checkname))}
        outF <- list(outputr = scan(batch.outname, skip=1))
        cat("from batch output file: ", batch.outname, fill = TRUE)
        nr <- length(outF$outputr)
    }
    temp <- list()
    class(temp) <- c("nnreg")
    temp$model <- read.NNREG(outF$outputr[1:nr], verbose = verbose)
    if (greedy) 
        temp$model <- netfit.reformat.greedy(temp$model)
    nfits <- length(temp$model)
    temp$fitted.values <- matrix(NA, ncol = nfits, nrow = length(y))
    if (!all.fits | fitted.values) {
        for (k in 1:nfits) {
            temp$fitted.values[, k] <- predict(temp$model[[k]], 
                x)
        }
        temp$residuals <- y - temp$fitted.values
    }
    temp$call <- call
    temp$x <- x
    temp$y <- y
    temp$n <- length(y)
    temp$nfits <- nfits
    temp$lags <- lags
    temp$seed <- seed
    hold <- summary(temp, noprint = TRUE)
    temp$best.model <- order(hold[, 6])[1]
    return(temp)
}
