\name{predict.netfit}
\alias{predict.netfit}
\title{
  Evaluation of a neural net fit based on a model component  
}
\description{
Provides a prediction based on a netfit object.
}
\usage{
predict.netfit(fit, x, derivative=0, type="full")
}
\arguments{
\item{fit}{
A component of the model list from an nnreg object (see example).  
The netfit object is just a list with the parameter vector and other model 
information. 
}
\item{x}{
A matrix of x values on which to evaluate the neural net surface. 
}
\item{derivative}{
Derivative of function are returned if derivative=1. 
}
\item{type}{
If 'full' the predicted values. If 'terms' each separate term in the 
neural 
net sum is returned a separate column in a matrix.
}
}

\value{
A vector of predicted responses. If derivative= 1 a vector of derivatives
(univariate x)   
or a matrix of partial derivatives is returned. 
If type="terms" and derivative=0 a matrix is returned where each column
is a component from the sum of neural net elements. This is useful for 
examining the contribution of each hidden unit in the neural network 
model. 
To be precise, the full estimate is 

f(x) = beta.0 +  sum beta.j*phi(t(gamma.j) x)  

where phi is  the neural net logisitic functions.
The "terms" option returns each hidden unit term, 
beta.j*phi(t(gamma.j)x), 
in a separate column. 
}
\seealso{
nnreg, predict.nnreg  
}
\examples{
nnreg(ozone$x,ozone$y,1,2) -> fit           # nnreg fit 
cbind( seq(87,89,,3),seq(40,42,,3)) -> x   # new x 
predict(fit$model[[1]],x) -> out            # evaluate model 1 at x 
}
\keyword{neural}
