\name{surface.nnreg}
\alias{surface.nnreg}
\title{
  Plots the predicted surface from an nnreg fit 
}
\description{
Plots a surface of the neural net regression fit for two coordinates 
holding the others fixed. Supported plot types are wire frame, contours 
and image.  
}
\usage{
surface.nnreg(obj, grid.list = NA, extrap = F, graphics.reset = NULL, 
xlab =NULL, ylab = NULL, main = NULL, zlab = NULL, zlim = NULL, levels = NULL,
        type = "b", ...)
}
\arguments{
\item{obj}{
An nnreg object 
}
\item{grid.list}{
A list with as many components as variables describing the surface. 
All components should have a single value except the two that give the 
grid points for evaluation. If the matrix or data frame has column names,  
these must appear in the grid list. 
}
\item{extrap}{
Extraplolation beyond the range of the data. If F the surface will only be 
evaluated inside of the convex hull when the observations are 
projected on the 2-d plane for plotting. }
\item{graphics.reset} {
If true will reset graphics panel parameters back to the original values. 
This is mainly for the case when type="b", two plots are drawn.
}
\item{xlab}{
Label for x axis}
\item{ylab}{
Label for y axis}
\item{main}{
Title for plot}
\item{zlab}{
Label for z axis}
\item{zlim}{
Limits for Z axis}
\item{levels}{
Level values for contour plot.} 
\item{type}{
The type of surface plot(s). 
"c" contour plot (contour). "b" a two panel figure with
perspective and contour plots. "I" image plot with legend
strip (see image.plot). "C" image plot with contours overlaid.
"b" the perspective and contour is the default.
}
\item{\dots}{
Any other ploting options. These are passed to specific R function drawing 
the plot. 
}
}
\details{

The main advantage of this function is to get a quick 2-d visualization of
the fitted surface. Stacking a prespective surface plot over a contour
plot is often a useful way to get a rapid idea of the shape of the
surface.

This function is essentially a combination of the fields functions
predict.surface and plot.surface.  The default of extrap=F is designed to
discourage looking at the estimated surface outside the range of the
observations. } 
\seealso{ nnreg, surface, image.plot, predict.surface,
persp, contour, grid.list} 

\examples{ nnreg(ozone$x,ozone$y,1,3) -> fit 
# fitting asurface to ozone surface(fit) 
# plots surface and contours of nnreg fit 
#no need to mess with the grid list because this is a 2-d data set.  

nnreg(as.matrix(BD[,1:4]),BD$lnya,1,1) -> fit 
#
# fitting a DNA strand 
# displacement amplification surface to various buffer compositions
# the columns names of the 4 X variables are 
# MgCl2 ,dNTP,KCl KPO4
#

surface(fit,grid.list=list(MgCl2='x',dNTP='y',KCl=35,KPO4=20)) 

# plots surface on MgCl2 X dNTP grid at specific KCL and KPO4 levels 

}
\keyword{hplot}
% docclass is function 
% Converted by Sd2Rd version 1.21.
