### Name: rdist
### Title: Euclidean distance matrix
### Aliases: rdist fields.rdist.near
### Keywords: spatial

### ** Examples


out<- rdist( ozone$x)
# out is a 20X20 matrix.

out2<- rdist( ozone$x[1:5,], ozone$x[11:20,])
#out2 is a 5X10 matrix

set.seed(123)
x1<- matrix( runif( 20*2), 20,2)
x2<-  matrix( runif( 15*2), 15,2)

out3<- fields.rdist.near( x1,x2, delta=.5)
# out3 is a sparse structure in list format

# or to "save"  work space decrease size of temp array

 out3<- fields.rdist.near( x1,x2, delta=.5,max.points=20*15)

# explicitly reforming as a full matrix 
temp<- matrix( NA, nrow=out3$da[1], ncol= out3$da[2])
temp[ out3$ind] <- out3$ra 

#       or justuse 

  temp<- spind2full( out3)
  image( temp)

# this is  identical to 
 temp2<- rdist( x1,x2)
 temp2[ temp2<= .5] <- NA




