#include "auto_gamma.h"

int main(int argc, char *argv[])
{
   time_t *tp, t_tmp;
   double b, *alpha, **beta, *upper, *lower;
   int steps=0, not_coalesced, i, j, t, T, rep, **seeds[MAX], k, min_bct=9999,
       max_bct=0, rep_num;
   char line[NUM];
   FILE *fp;

   fp=fopen("out.txt","w");
   t_tmp=time(tp);
   srand(t_tmp%10000);

   printf("Enter the number of draws you need:\n");
   fgets(line,NUM-1,stdin);
   t=sscanf(line,"%i",&rep_num);
   if((t!=1) || (rep_num<=0))
   {
      printf("Please restart and enter an integer>0 for k. Thank you.\n");
      exit(1);
   }

   printf("Enter k (dimension of sample space):\n");
   fgets(line,NUM-1,stdin);
   t=sscanf(line,"%i",&k);
   if((t!=1) || (k<=0))
   {
      printf("Please restart and enter an integer>0 for k. Thank you.\n");
      exit(1);
   }

   ALLOCATE;

   for(i=0;i<k;i++)
   {
      printf("Enter alpha(%i):\n",i+1);
      fgets(line,NUM-1,stdin);
      t=sscanf(line,"%lf",&alpha[i]);
      if((t!=1) || (alpha[i]<0))
      {
         printf("Please restart and enter a number>=0 for k. Thank you.\n");
         exit(1);
      }

      printf("Enter beta(%i):\n",i+1);
      fgets(line,NUM-1,stdin);
      t=sscanf(line,"%lf",&beta[i][i]);
      if((t!=1) || (beta[i][i]<0))
      {
         printf("Please restart and enter a number>=0 for k. Thank you.\n");
         exit(1);
      }

      for(j=i+1;j<k;j++)
      {
         printf("Enter beta(%i,%i):\n",i+1,j+1);
         fgets(line,NUM-1,stdin);
         t=sscanf(line,"%lf",&beta[i][j]);
         beta[j][i]=beta[i][j];
         if((t!=1) || (beta[i][j]<0))
         {
            printf("Please restart and enter a number>=0 for k. Thank you.\n");
            exit(1);
         }
      }
      printf("\n");
   }

   for(rep=0;rep<rep_num;rep++)
   {
      T=0;
      not_coalesced=1;
      comp_seeds(seeds,k);

      while(not_coalesced)
      {
         T--;
         if(-T>=MAX)
	 {
            printf("Sorry, the variable MAX too small!\n");
            printf("Please open file 'autogamma.h' and increase the variable MAX on line 9.\n");
            printf("Then recompile and start the program again. Thank you.\n");
            exit(1);
	 }
         initialize(lower,upper,alpha,beta,seeds[-T],k);

         for(t=T;t<0;t++)
            update_chain(lower,upper,alpha,beta,b,seeds[-t-1],k);

         not_coalesced=check_coalescence(lower,upper,k);
      }

      steps+=-T;
      if(-T>max_bct)
         max_bct=-T;
      if(-T<min_bct)
         min_bct=-T;
      for(i=0;i<k;i++)
         fprintf(fp,"%f \t",lower[i]);
      fprintf(fp,"\n");
   }
   
   fclose(fp);   

   printf("average backward coupling time was %f\n",(double) steps/rep_num);
   printf("minimum backward coupling time was %i\n",min_bct);
   printf("maximum backward coupling time was %i\n",max_bct);
   printf("\n");
   printf("Your draws are stored in file 'out.txt'.\n");
   printf("Goodbye.\n");
   printf("\n");
   return(0);

}







