#include "auto_gamma.h"

double find_limit(double alpha, double beta, double x, double y, double c, 
                  double peak)
{
   double r, f=0, inc=0.01;

   if(alpha<=1)
   {
      r=x+inc;
      f=gamma_dens(alpha,beta,r);

      while(f>y)
      {
         r+=inc;
         f=gamma_dens(alpha,beta,r);
      }
   }

   else
   {
      if(x>peak)
         r=x;
      else
         r=peak;

      while(f<y)
      {
         r+=inc;
         f=c-gamma_dens(alpha,beta,r);
      }
   }

   return(r);

}
