#include "auto_gamma.h"

double shift_patch(double u,double l, double r, double alpha, double beta,
                   double peak,double s,double c, double y, double inc, 
                   int *flag)
{
   int patch;
   double f, u_s, bound, eps;

   eps=2*inc;
   bound=r-l-eps;
   

   if((bound>ABS(s)) && (eps<ABS(s)))
   {
      *flag=1;
      u=floor((s+r-u)/(r-l))*(r-l)+u;
      u_s=u-s;
      f=gamma_dens(alpha,beta,u_s);
      patch=0;

      if(u_s<peak) 
      {
         if(f<y)
            patch=1;
      }
      else
      {
         if(c-f>y)
            patch=1;
      }

      if(patch)
         u=floor((s+r-u_s)/(r-l))*(r-l)+u_s;
   }

   else
   {
      *flag=0;
      u=u+s;
   }

   return(u);
}
   



