#include "auto_gamma.h"

void slice_gamma2(double alpha, double beta, double beta_l, double beta_u, 
                  double *gamma_l, double *gamma_u, int *seed)
{
   double a, x, y, r, c, peak, peak_l, peak_u, u, gamma;

   srand48(seed[0]);

   if(alpha<1)
   {
      x=sim_gamma(alpha,beta);
      y=drand48()*gamma_dens(alpha,beta,x);
      r=find_limit(alpha,beta,x,y,0,0);
      gamma=drand48()*r;
      gamma=draw_unif(gamma,alpha,beta,y,0,0);

      *gamma_l=draw_unif(gamma,alpha,beta_l,y,1,seed[1]);
      *gamma_u=draw_unif(gamma,alpha,beta_u,y,1,seed[1]);
   }
 
   else  
   {
      a=alpha-1;
      c=pow(a,a)*exp(-a);
      peak=a/beta;
      peak_l=a/beta_l;
      peak_u=a/beta_u;

      x=sim_gamma(alpha,beta);
      u=drand48();
      y=draw_y(alpha,beta,u,x,peak,c);
      r=find_limit(alpha,beta,x,y,c,peak);

      *gamma_l=accept_reject(alpha,beta_l,c,peak_l,y,r,seed[1]);
      *gamma_u=accept_reject(alpha,beta_u,c,peak_u,y,r,seed[1]);

   }
}

